/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
namespace Inet.Viewer.Helper
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// 
    /// </summary>
    public static class Collections
    {
        /// <summary>
        /// Creates a copy of the source IDictionary and puts all
        /// entries into the dest IDictionary
        /// </summary>
        /// <param name="dest"></param>
        /// <param name="source"></param>
        public static void PutAll<TKey, TValue>(IDictionary<TKey, TValue> dest, IDictionary<TKey, TValue> source)
        {
            foreach (KeyValuePair<TKey, TValue> entry in source)
            {
                if (!dest.ContainsKey(entry.Key))
                {
                    dest.Add(entry.Key, entry.Value);
                }
            }
        }

        /// <summary>
        /// Content compares two Dictionaries
        /// </summary>
        /// <typeparam name="TKey"></typeparam>
        /// <typeparam name="TValue"></typeparam>
        /// <param name="first">the first Dictionary</param>
        /// <param name="second">the second Dictionary</param>
        /// <returns>true if they are identical, false if they differ</returns>
        public static bool DictionaryEqual<TKey, TValue>(this IDictionary<TKey, TValue> first, IDictionary<TKey, TValue> second)
        {
            if (first == second) return true;
            if ((first == null) || (second == null)) return false;
            if (first.Count != second.Count) return false;

            var comparer = EqualityComparer<TValue>.Default;

            foreach (KeyValuePair<TKey, TValue> kvp in first)
            {
                TValue secondValue;
                if (!second.TryGetValue(kvp.Key, out secondValue)) return false;
                if (!comparer.Equals(kvp.Value, secondValue)) return false;
            }
            return true;
        }
    }
}